<?php
session_start();

include 'include/head.php';

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

if (!isset($_GET['id'])) {
    header('Location: responsables.php');
}

$id = $_GET['id'];

if (isset($_GET['supprimer'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();
        $requete = $bdd->prepare("DELETE FROM responsable WHERE id=:id");
        $requete->bindParam(':id', $id);
        $requete->execute();
        $bdd->commit();

        header('Location: responsables.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }
}

if (isset($_POST['nom'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();
        $requete = $bdd->prepare('UPDATE responsable SET nom_responsable=:nom, prenom_responsable=:prenom, num_rue_responsable=:num_rue, cp_responsable=:cp, ville_responsable=:ville, tel_responsable=:tel, id_eleve:id_eleve WHERE id=:id');
        $requete->bindParam(':nom', $_POST['nom']);
        $requete->bindParam(':prenom', $_POST['prenom']);
        $requete->bindParam(':num_rue', $_POST['adresse']);
        $requete->bindParam(':cp', $_POST['cp']);
        $requete->bindParam(':ville', $_POST['ville']);
        $requete->bindParam(':tel', $_POST['fixe']);
        $requete->bindParam(':id_eleve', $_POST['id_eleve']);
        $requete->bindParam(':id', $id);
        $requete->execute();
        $bdd->commit();

        header('Location: responsables.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }

}

$requete = $bdd->prepare("SELECT * FROM responsable WHERE id=:id");
$requete->bindParam(':id', $id);
$requete->execute();
$responsable = $requete->fetch();

include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading"> Modification d'un responsable - <a href="edition-responsable.php?id=<?php echo htmlspecialchars($id) ?>&supprimer">Supprimer ce responsable</a> </div>
                        <div class="panel-body">
                            <div class="form-group">
                                <form method="post">
                                    <label>Nom</label>
                                    <input class="form-control" name="nom" value="<?php echo htmlspecialchars($responsable['nom_responsable']) ?>">
                                    <label>Prénom</label>
                                    <input class="form-control" name="prenom" value="<?php echo htmlspecialchars($responsable['prenom_responsable']) ?>">
                                    <label>Élève</label>
                                    <select class="form-control" name="id">
                                        <option value="">Aucun</option>
                                        <?php
                                        $requete = $bdd->prepare("SELECT nom, prenom, id_eleve FROM eleve");
                                        $requete->execute();
                                        while ( $row = $requete->fetch())
                                            echo '<option value="'.htmlspecialchars($row['id_eleve']).'">'.htmlspecialchars($row['prenom'].' '.$row['nom']).'</option>';
                                        ?>
                                    </select>
                                    <label>Adresse</label>
                                    <input class="form-control" name="adresse" value="<?php echo htmlspecialchars($responsable['num_rue_responsable']) ?>">
                                    <label>Code postal</label>
                                    <input class="form-control" name="cp" value="<?php echo htmlspecialchars($responsable['cp_responsable']) ?>">
                                    <label>Ville</label>
                                    <input class="form-control" name="ville" value="<?php echo htmlspecialchars($responsable['ville_responsable']) ?>">
                                    <label>Téléphone</label>
                                    <input class="form-control" name="tel" value="<?php echo htmlspecialchars($responsable['tel_responsable']) ?>">
                                    <br />
                                    <input type="submit">
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
